package com.example.bytesbee.alphabets.activities;

import static com.example.bytesbee.alphabets.activities.constants.IConstants.EXTRA_LINK;
import static com.example.bytesbee.alphabets.activities.constants.IConstants.EXTRA_NAME;

import android.app.Activity;
import android.content.res.AssetManager;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;

import com.example.bytesbee.alphabets.activities.R;
import com.example.bytesbee.alphabets.activities.utils.SessionManager;
import com.example.bytesbee.alphabets.activities.utils.Utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class WebViewBrowserActivity extends AppCompatActivity {

    private WebView webView;
    private Activity mActivity;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_webview);
        mActivity = this;
        try {
            final Toolbar mToolbar = findViewById(R.id.toolbar);
            setSupportActionBar(mToolbar);
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            getSupportActionBar().setTitle(getIntent().getStringExtra(EXTRA_NAME));
            mToolbar.setNavigationOnClickListener(v -> onBackPressed());
        } catch (Exception e) {
            Utils.getErrors(e);
        }

        Utils.loadBannerAd(mActivity);

        final SessionManager session = new SessionManager(mActivity);
        final String linkPath = getIntent().getStringExtra(EXTRA_LINK);

        webView = findViewById(R.id.webView);
        final ProgressBar progressBar = findViewById(R.id.determinateBar);
        progressBar.setVisibility(View.GONE);

        if (linkPath.startsWith("http")) {

            webView.getSettings().setDefaultTextEncodingName("UTF-8");
            webView.requestFocusFromTouch();
            webView.setWebChromeClient(new WebChromeClient());
            webView.getSettings().setAllowContentAccess(true);
            webView.getSettings().setDomStorageEnabled(true);
            webView.getSettings().setUseWideViewPort(true);
            webView.getSettings().setLoadWithOverviewMode(true);

            webView.getSettings().setMediaPlaybackRequiresUserGesture(false);

            webView.setWebViewClient(new WebClientAboveLollipop(progressBar));
            webView.loadUrl(linkPath);
        } else {

            StringBuilder sb = new StringBuilder();
            try {
                InputStream is = getAssets().open(linkPath);
                BufferedReader br = null;
                br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                String str;
                while ((str = br.readLine()) != null) {
                    sb.append(str);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

            try {
                String mimeType = "text/html;charset=UTF-8";
                String encoding = "utf-8";
                String htmlText = sb.toString();
                String rtl = session.isRTLOn() ? "dir=\"rtl\"" : "";

                String text = "<html><head>"
                        + "<style type=\"text/css\">@font-face {font-family: MyFont;src: url(\"file:///android_asset/fonts/sansation_regular.ttf\")}body{font-family: MyFont;color: #383838;}"
                        + "</style></head>"
                        + "<body " + rtl + ">"
                        + htmlText
                        + "</body></html>";

                webView.loadDataWithBaseURL(null, text, mimeType, encoding, null);
            } catch (Exception e) {
                try {
                    webView.loadUrl("file:///android_asset/" + linkPath);
                } catch (Exception en) {
                    Utils.getErrors(en);
                }
            }
        }
    }

    private void loadUrl(String url) {
        webView.loadUrl(url);
    }

    private class WebClientAboveLollipop extends WebViewClient {
        private ProgressBar progressBar;

        public WebClientAboveLollipop(ProgressBar progressBar) {
            this.progressBar = progressBar;
            progressBar.setVisibility(View.VISIBLE);
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            loadUrl(request.getUrl().toString());
            return true;
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            progressBar.setVisibility(View.GONE);
        }
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        try {
            webView.loadUrl("");
        } catch (Exception ignored) {
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    @Override
    public AssetManager getAssets() {
        return getResources().getAssets();
    }
}
